import string
import itertools
from pwn import *

# === Configuration ===
HOST = '129.226.145.210'
PORT = 317

# === Hashing Logic (Reversed from C) ===
def calculate_hash(s):
    v13 = 1
    for char in s:
        c = ord(char)
        v13 = c ^ (v13 >> 1) # The rolling XOR

    first = ord(s[0])
    v15 = len(s)

    # The check found in the 'if' statements:
    # ((unsigned __int8)(16 * (*pBuf1024 ^ v18)) | (unsigned __int64)(State & 0xF))
    # v18 in C was calculated using pointer math, effectively just the length for small strings
    
    term1 = ((first ^ v15) & 0xF) << 4
    term2 = v13 & 0xF
    return term1 | term2

def find_collision(target_hash):
    # Brute force 2 char strings (efficient and keeps payload short)
    chars = string.ascii_letters + string.digits
    for s in itertools.product(chars, repeat=2):
        word = "".join(s)
        if calculate_hash(word) == target_hash:
            return word
    # Fallback to 1 char if needed
    for s in chars:
        if calculate_hash(s) == target_hash:
            return s
    return None

# === Payload Construction ===
# Logic: ((30 + 1) * 1000) + (3 * 100) + 30 + 7 = 31337
needed_hashes = {
    'ADD_30': 0x27,
    'ADD_1':  0xC9,
    'MUL_1k': 0xC0,
    'ADD_3':  0x11,
    'MUL_100':0xF2,
    'ADD_7':  0x6A
}

print("[*] Finding collisions...")
word_map = {}
for name, h in needed_hashes.items():
    word = find_collision(h)
    if word:
        print(f"    {name:<8} (0x{h:02X}) -> {word}")
        word_map[name] = word
    else:
        log.error(f"Could not find collision for {name}")

# Construct the sequence
payload_tokens = [
    word_map['ADD_30'],  # 30
    word_map['ADD_1'],   # 31
    word_map['MUL_1k'],  # Move 31000 to HighPart, Acc=0
    word_map['ADD_3'],   # 3
    word_map['MUL_100'], # 300
    word_map['ADD_30'],  # 330
    word_map['ADD_7']    # 337
]

payload = " ".join(payload_tokens)
print(f"[*] Payload length: {len(payload)}")
print(f"[*] Payload: {payload}")

# === Exploitation ===
r = remote(HOST, PORT)
r.recvuntil(b'Input > ')
r.sendline(payload.encode())

# Interaction to grab flag
r.interactive()