#include <defs.h>
#include <stdio.h>
#include <stdint.h>

// Assuming context from RISC-V disassembly analysis
// Register mappings (typical RISC-V ABI):
// a0-a7: arguments/temporaries
// s0-s11: saved registers
// sp: stack pointer
// Global variables
uint64_t qword_898F0 = 0;
uint64_t A_ccumulator = 0;

void loc_1052E(uint64_t *qword_ptr, uint64_t initial_value, uint8_t *s, 
               uint64_t A_ccumulator_val, uint64_t B_HighPart) {
    
    // 0x1052E: sd a3, 0(a5)
    *qword_ptr = initial_value;  // qword_898E8 = 1
    
    // 0x10530: sd zero, qword_898F0
    qword_898F0 = 0;
    
    // 0x10534: lbu a2, 0(a4)
    uint64_t v21 = *s;
    
    // 0x10538: beqz a2, loc_10594
    if (v21 == 0) goto loc_10594;
    
    // 0x1053A: mv s8, a4
    uint8_t *pBuf1024_2 = s;
    
    // 0x1053C: li a2, 1
    v21 = 1;
    
    // 0x1053E: sub s10, a3, a4
    uint64_t pBuf1024End = initial_value - (uint64_t)s;
    
    // C23 extension fix: declare before label
    uint64_t Buf1024End;
    uint64_t v24;
    uint64_t first_byte;
    uint64_t low_nibble;
    uint64_t high_nibble;
    uint64_t t;
    uint64_t Multiplier;
    uint64_t stack_value;
    uint64_t v25;
    
loc_10542:
    // 0x10542: add s9, s10, s8
    Buf1024End = pBuf1024End + (uint64_t)pBuf1024_2;
    
    // 0x10546: srai a2, a2, 1
    v21 = (int64_t)v21 >> 1;
    
    // 0x10548: sd a2, 0(a5)
    *qword_ptr = v21;
    
    // 0x1054A: sd s9, 8(a5)
    *(qword_ptr + 1) = Buf1024End;
    
    // 0x1054E: lbu s11, 0(s8)
    v24 = *pBuf1024_2;
    
    // 0x10552: addi s8, s8, 1
    pBuf1024_2++;
    
    // 0x10554: xor a2, s11, a2
    v21 = v24 ^ v21;
    
    // 0x10558: sd a2, 0(a5)
    *qword_ptr = v21;
    
    // 0x1055A: lbu s11, 0(s8)
    v24 = *pBuf1024_2;
    
    // 0x1055E: bnez s11, loc_10542
    if (v24 != 0) goto loc_10542;
    
    // 0x10562: lbu s8, 0(a4)
    first_byte = *s;
    
    // 0x10566: andi a2, a2, 0x0F
    low_nibble = v21 & 0x0F;
    
    // 0x10568: xor s8, s8, s9
    first_byte = first_byte ^ Buf1024End;
    
    // 0x1056C: slliw s8, s8, 4
    first_byte = (uint64_t)((uint32_t)first_byte << 4);
    
    // 0x10570: andi s8, s8, 0xFF
    high_nibble = first_byte & 0xFF;
    
    // 0x10574: or a2, s8, a2
    t = high_nibble | low_nibble;
    
    // 0x10578: bne a2, s5, loc_10594
    if (t >= 0 && (t == 0x82 || t == 0x4c || t == 0x6a || t == 0x4c || t == 0xaf || t == 0x10 || t == 0x6f || t == 0x10 || t == 0x00 || t == 0x4c))
        printf("[%02x%02x%02x] (%c%c%c) %llx\n", s[0], s[1], s[2], s[0], s[1], s[2], t);
    
    // 0x1057C: ld a2, 0x10(a5)
    Multiplier = *(qword_ptr + 2);
    
    // 0x1057E: sd zero, A_ccumulator
    A_ccumulator = 0;
    
    // 0x10582: ld s8, 8(sp)
    stack_value = 1000000000;  // Inferred from pseudocode
    
    // 0x10584: mul a2, a1, a2
    v25 = A_ccumulator_val * Multiplier;
    
    // 0x10588: li a1, 0
    A_ccumulator_val = 0;
    
    // 0x1058A: mul a2, a2, s8
    v25 = v25 * stack_value;
    
    // 0x1058E: add a6, a6, a2
    B_HighPart = B_HighPart + v25;
    
    // 0x10590: sd a6, 0x20(a5)
    *(qword_ptr + 4) = B_HighPart;
    
loc_10594:
    return;
}
int main() {
  uint64_t storage[5] = {0};

  for (uint8 ccc = 0; ccc != 255; ccc++)
      for (uint8 cc = 0; cc != 255; cc++)
          for (uint8 c = 0; c != 255; c++)
  {
      unsigned char s[4];
      s[0] = c;
      s[1] = cc;
      s[2] = ccc;
      s[3] = '\0';
      loc_1052E(storage, 1, s, 0, 0);
  }
  return 0;
}
