#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <defs.h>

// --- Helper Functions ---

// Rotate Left 32-bit
uint32_t rol(uint32_t val, int r_bits) {
    return (val << (r_bits % 32)) | (val >> (32 - (r_bits % 32)));
}

// Rotate Right 32-bit
uint32_t ror(uint32_t val, int r_bits) {
    return (val >> (r_bits % 32)) | (val << (32 - (r_bits % 32)));
}

// Xorshift32 PRNG (sub_14F0)
uint32_t xorshift32(uint32_t state) {
    state ^= (state << 13);
    state ^= (state >> 17);
    state ^= (state << 5);
    return state;
}

// --- Logic ---

void generate_key(const char* username) {
    uint32_t v11 = 0xA5397617; // -1522754025
    uint32_t v12 = 0xC0FFDE25; // -1056969179
    size_t len = strlen(username);

    // 1. Hashing Loop
    for (size_t i = 0; i < len; i++) {
        uint8_t c = (uint8_t)username[i];
        
        // Update v12
        uint32_t term = (c + 257 * v12);
        v12 = rol(term, 5) ^ 0xA5C3D2E1;
        
        // Update v11
        uint32_t term2 = (v11 + 31 * c);
        uint32_t term3 = term2 ^ ror(v12, 3);
        v11 = 17 * term3 + 61;
    }

    // 2. Post-processing
    // Magic constant: 668265261 -> 0x27D4EB2D
    uint32_t v14 = v12 ^ (0x27D4EB2D * (uint32_t)len);
    uint32_t v15 = v11 ^ rol(v14, 13);

    // 3. Extract Parts
    uint16_t part2 = (uint16_t)((v15 & 0xFFFF) ^ (v14 & 0xFFFF));
    
    uint16_t term_p3 = (uint16_t)((v15 >> 5) ^ rol(v14, 11));
    uint16_t part3 = term_p3 ^ 0xBEEF;
    
    uint16_t term_p4 = (uint16_t)(ror(v15, 9) + 3 * v14);
    uint16_t part4 = term_p4 ^ 0xC0DE;

    printf("[*] Key for '%s': CW25-%04X-%04X-%04X\n", username, part2, part3, part4);
}

void decrypt_flag() {
    // TODO: COPY BYTES FROM IDA (unk_2040)
    // Select the bytes in IDA -> Shift+E -> 'C byte array'
    unsigned char encrypted_flag[] = { 
        0x89, 0x5C, 0x9D, 0x8A, 0x66, 0x4A, 0xA8, 0x4F, 0x51, 0xB5, 0xF3, 0xC0, 0xD9, 0x53, 0xFF, 0xF1, 0xBB, 0x85, 0xA1, 0x7C, 0x30, 0x9F, 0x54, 0x51, 0xAF, 0xE9, 0x65, 0xD3, 0x91, 0xE2, 0x2F, 0xD2, 0x69, 0x82, 0x9D, // PLACEHOLDER! REPLACE THESE!
        // ... need the full 36 bytes here
    };

    uint32_t seed = 322420463;
    size_t size = sizeof(encrypted_flag);

    if (encrypted_flag[0] == 0 && size <= 4) {
        printf("[!] ERROR: You need to paste the bytes from unk_2040 into the source code first.\n");
        return;
    }

    printf("[*] Decrypted Flag: ");
    for (size_t i = 0; i < size; i++) {
        seed = xorshift32(seed);
        char decrypted_char = encrypted_flag[i] ^ (seed & 0xFF);
        printf("%c", decrypted_char);
    }
    printf("\n");
}

 __int64 goda(int a1)
{
  return a1
       ^ (a1 << 13)
       ^ ((a1 ^ (unsigned int)(a1 << 13)) >> 17)
       ^ (32 * (a1 ^ (a1 << 13) ^ ((a1 ^ (unsigned int)(a1 << 13)) >> 17)));
}
void dec() {
    char flag[36];
    char* flag_ptr;
    flag_ptr = flag;
    unsigned int rand = 322420463;
    char enc_flag[] = {0x89, 0x5C, 0x9D, 0x8A, 0x66, 0x4A, 0xA8, 0x4F, 0x51, 0xB5, 0xF3, 0xC0, 0xD9, 0x53, 0xFF, 0xF1, 0xBB, 0x85, 0xA1, 0x7C, 0x30, 0x9F, 0x54, 0x51, 0xAF, 0xE9, 0x65, 0xD3, 0x91, 0xE2, 0x2F, 0xD2, 0x69, 0x82, 0x9D};
    char* enc = (char *)enc_flag;
    do
    {
      ++enc;
      ++flag_ptr;
      rand = goda(rand);
      *(flag_ptr-1) =  (unsigned __int8)*(enc-1) ^ (unsigned __int8)rand;
    }
    while ( enc != (char *)&enc_flag + 36 );
    puts(flag);
} 

int main() {
    // Generate a valid key
    // generate_key("ADMIN");

    // Decrypt the flag (Requires unk_2040 bytes)
    dec();

    return 0;
}
