import ctypes

encrypted_data = [
    0xB9, 0x89, 0x5C, 0x9D, 0x8A, 0x66, 0x4A, 0xA8, 
    0x4F, 0x51, 0xB5, 0xF3, 0xC0, 0xD9, 0x53, 0xFF, 
    0xF1, 0xBB, 0x85, 0xA1, 0x7C, 0x30, 0x9F, 0x54, 
    0x51, 0xAF, 0xE9, 0x65, 0xD3, 0x91, 0xE2, 0x2F, 
    0xD2, 0x69, 0x82, 0x9D
]

def get_rng_keystream(seed, length):
    state = seed
    keys = []
    for _ in range(length):
        state = ctypes.c_uint32(state).value
        
        term1 = ctypes.c_uint32(state << 13).value
        state ^= term1
        
        term2 = state >> 17
        state ^= term2
        
        term3 = ctypes.c_uint32(state << 5).value
        state ^= term3
        
        keys.append(state & 0xFF)
    return keys

def solve():
    seed = 0x1337BEEF
    keystream = get_rng_keystream(seed, len(encrypted_data))
    
    flag_chars = []
    for enc, key in zip(encrypted_data, keystream):
        flag_chars.append(chr(enc ^ key))
            
    print(f"Flag: {''.join(flag_chars)}")

if __name__ == "__main__":
    solve()